
CREATE TABLE [dbo].[FACT_SPECIALTY_TRANSFER_ETL](
	[IEN] [varchar](50) NULL,
	[DIM_PATIENT_ID] [nvarchar](250) NULL,
	[DIM_DOMAIN_ID] [nvarchar](50) NOT NULL,
	[VISTA_SITE_DIM_ORGANIZATION_ID] [nvarchar](250) NULL,
	[DATE_TIME] [datetime] NULL,
	[TYPE_OF_MOVEMENT_CODE] [varchar](100) NULL,
	[ENTERED_DATE] [datetime] NULL,
	[ENTERED_BY_ID] [nvarchar](250) NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL,
	[SOURCE_ID] [int] NOT NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contains temporary specialty transfer information from bms database. Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FACT_SPECIALTY_TRANSFER_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_DIM_DOMAIN_ID] ON [dbo].[FACT_SPECIALTY_TRANSFER_ETL] 
(
	[DIM_DOMAIN_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_DIM_PATIENT_ID] ON [dbo].[FACT_SPECIALTY_TRANSFER_ETL] 
(
	[DIM_PATIENT_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_ENTERED_BY_ID] ON [dbo].[FACT_SPECIALTY_TRANSFER_ETL] 
(
	[ENTERED_BY_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[FACT_SPECIALTY_TRANSFER_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_TYPE_OF_MOVEMENT_CODE] ON [dbo].[FACT_SPECIALTY_TRANSFER_ETL] 
(
	[TYPE_OF_MOVEMENT_CODE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_VISTA_SITE_DIM_ORGANIZATION_ID] ON [dbo].[FACT_SPECIALTY_TRANSFER_ETL] 
(
	[VISTA_SITE_DIM_ORGANIZATION_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO